/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/


var omu_aUtilisateurs = new Arbre("Utilisateurs/Utilisateurs/list-utilisateur.tmpl", "omu-listeUtilisateurs");
var omu_qListFU = new QueryHttp("Utilisateurs/Utilisateurs/getDataListFU.tmpl");

var omu_pageCourante;
var omu_nbPages;



function omu_init() {
	try {

		document.getElementById('omu-login').focus();

		omu_loadChiffresCles();

	} catch (e) {
		recup_erreur(e);
	}
}


function omu_pressOnNouveauUtilisateur() {
	try {

		document.getElementById("bMenuUtilisateurs").collapsed = false;
		document.getElementById("deck").selectedIndex = 1;
		ofu_nouveauUtilisateur();

	} catch (e) {
		recup_erreur(e);
	}
}


function omu_initCriteres() {
	try {

		document.getElementById('omu-login').value = "";
		document.getElementById('omu-nom').value = "";
		document.getElementById('omu-actif').checked = true;

		omu_listerUtilisateurs();

	} catch (e) {
		recup_erreur(e);
	}
}


function omu_listerUtilisateurs() {
	try {

		var login = document.getElementById('omu-login').value;
		var nom = document.getElementById('omu-nom').value;
		var actif = document.getElementById('omu-actif').checked;
		var nbLignesParPage = document.getElementById('omu-nbLignesParPage').value;

		omu_pageCourante = 1;
		omu_nbPages = 1;
		document.getElementById('omu-pageDeb').value = 1;
		document.getElementById('omu-pageFin').value = 1;
		document.getElementById('omu-bPrec').disabled = true;
		document.getElementById('omu-bSuiv').disabled = true;

		document.getElementById('omu-listeUtilisateurs').disabled = true;
		document.getElementById('omu-bEditionCsv').disabled = true;
		omu_aUtilisateurs.deleteTree();

		omu_qListFU.setParam("Login", login);
		omu_qListFU.setParam("Nom", nom);
		omu_qListFU.setParam("Actif", actif);
		omu_qListFU.setParam("Nb_Lignes_Par_Page", nbLignesParPage);
		omu_qListFU.setParam("Current_Page", omu_pageCourante);

		var result = omu_qListFU.execute();

		var contenu = result.responseXML.documentElement;

		omu_nbPages = contenu.getAttribute("Nb_Pages");
		var listUtilisateurId = contenu.getAttribute("List_Utilisateur_Id");

		omu_aUtilisateurs.setParam("List_Utilisateur_Id", listUtilisateurId);
		omu_aUtilisateurs.initTree(omu_initPagination);

	} catch (e) {
		recup_erreur(e);
	}
}


function omu_initPagination() {
	try {

		document.getElementById('omu-pageDeb').value = omu_pageCourante;
		document.getElementById('omu-pageFin').value = (omu_nbPages>0?omu_nbPages:1);
		document.getElementById('omu-bPrec').disabled = (omu_pageCourante==1);
		document.getElementById('omu-bSuiv').disabled = (omu_pageCourante>=omu_nbPages); // peut se produire si omu_nbPages=0

		omu_afterMajPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function omu_pressOnPagePrec() {
	try {

		omu_pageCourante--;
		omu_majPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function omu_pressOnPageSuiv() {
	try {

		omu_pageCourante++;
		omu_majPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function omu_majPagination() {
	try {

		document.getElementById('omu-pageDeb').value = omu_pageCourante;
		document.getElementById('omu-bPrec').disabled = (omu_pageCourante==1);
		document.getElementById('omu-bSuiv').disabled = (omu_pageCourante==omu_nbPages);

		document.getElementById('omu-listeUtilisateurs').disabled = true;
		document.getElementById('omu-bEditionCsv').disabled = true;

		omu_qListFU.setParam("Current_Page", omu_pageCourante);
		var result = omu_qListFU.execute();
		var listUtilisateurId = result.responseXML.documentElement.getAttribute("List_Utilisateur_Id");

		omu_aUtilisateurs.setParam("List_Utilisateur_Id", listUtilisateurId);
		omu_aUtilisateurs.initTree(omu_afterMajPagination);

	} catch (e) {
		recup_erreur(e);
	}
}


function omu_afterMajPagination() {
	try {

		document.getElementById('omu-listeUtilisateurs').disabled = false;
		document.getElementById('omu-bEditionCsv').disabled = (omu_aUtilisateurs.nbLignes()==0);

	} catch (e) {
		recup_erreur(e);
	}
}


function omu_pressOnCritere(ev) {
  try {

		if (ev.keyCode==13) {
			omu_listerUtilisateurs();
    }

	} catch (e) {
  	recup_erreur(e);
  }
}


function omu_pressOnListeUtilisateurs(ev) {
	try {

		if (ev.keyCode==13) {
			omu_ouvrirUtilisateur();
    }

	} catch (e) {
		recup_erreur(e);
	}
}


function omu_ouvrirUtilisateur() {
  try {

  	if (omu_aUtilisateurs.isSelected()) {

			ofu_utilisateurId = omu_aUtilisateurs.getSelectedCellText('omu-colUtilisateurId');
			document.getElementById('bMenuUtilisateurs').collapsed = false;

			ofu_chargerUtilisateur();

			document.getElementById('deck').selectedIndex = 1;
  	}

	} catch (e) {
  	recup_erreur(e);
  }
}


function omu_pressOnEditionCsv() {
	try {

		var login = document.getElementById('omu-login').value;
		var nom = document.getElementById('omu-nom').value;
		var actif = document.getElementById('omu-actif').checked;

		var qEditionCsv = new QueryHttp("Utilisateurs/Utilisateurs/csvUtilisateur.tmpl");
		qEditionCsv.setParam("Login", login);
		qEditionCsv.setParam("Nom", nom);
		qEditionCsv.setParam("Actif", actif);

		var result = qEditionCsv.execute();
		var fichier = result.responseXML.documentElement.getAttribute('FichierCSV');

		var file = fileChooser("save", fichier);
		if (file!=null) {
			downloadFile(getDirBuffer()+ fichier, file);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function omu_loadChiffresCles() {
	try {

		var qStats = new QueryHttp("Utilisateurs/Utilisateurs/getStatsUtilisateur.tmpl");
		var result = qStats.execute();
		var contenu = result.responseXML.documentElement;

		document.getElementById("omu-nbFUTotal").value = contenu.getAttribute("Nb_FU_Total");
		document.getElementById("omu-nbFUTotalActif").value = contenu.getAttribute("Nb_FU_Total_Actif");

	} catch (e) {
		recup_erreur(e);
	}
}
