/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");



function init() {
  try {

    window.resizeTo(400,200);

		document.getElementById('Password').focus();

  } catch (e) {
    recup_erreur(e);
  }
}


function changer() {
  try {

		var utilisateurId = window.arguments[0];
  	var password = document.getElementById('Password').value;
		var password2 = document.getElementById('Password2').value;

		if (isEmpty(password)) {
			showWarning("Mot de passe manquant");
		}
		else if (password.length<8) { showWarning("Le mot de passe doit contenir au minimum 8 caract\u00E8res"); }
		else if (!isValidPassword(password)) { showWarning("Le mot de passe doit contenir au moins 3 des 4 types de caract\u00E8res (minuscule, majuscule, chiffre, car. sp\u00E9cial)"); }
		else if (password2 != password) {
			showWarning("Les mots de passe saisis sont diff\u00E9rents.\nVeuillez reconfirmer le mot de passe");
			document.getElementById('Password2').value = "";
		}
		else {
			var qMaj = new QueryHttp("Utilisateurs/Utilisateurs/updatePasswordUtilisateur.tmpl");
			qMaj.setParam('Password', password);
			qMaj.setParam('Utilisateur_Id', utilisateurId);
			var result = qMaj.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				showMessage("Le mot de passe a \u00E9t\u00E9 chang\u00E9 avec succ\u00E8s");
			}

			window.close();
		}

	} catch (e) {
    recup_erreur(e);
  }
}

